<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function types()
    {
        return $this->belongsTo('Type');
    }

    public function categories()
    {
        return $this->belongsToMany('Category');
    }

    public function model()
    {
        return $this->belongsTo('Model');
    }

    public function visibility()
    {
        return $this->belongsTo('Visibility');
    }

    public function images()
    {
        return $this->hasMany('Image');
    }

    public function combinaisons()
    {
        return $this->hasMany('Combination');
    }

    public function taxeGroup()
    {
        return $this->belongsTo('App\Models\TaxGroup');
    }

}